#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>

#include <opencv2/objdetect/objdetect.hpp>
#include <opencv2/features2d/features2d.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/calib3d/calib3d.hpp>
#include <opencv2/imgproc/imgproc_c.h>

#include "cam.h"

using namespace std;
using namespace cv;

int main(int argc, char* argv[])
{
	//wins
	cvNamedWindow("w1", 1);
	cvNamedWindow("w2", 1);
	//load video streams
	CvCapture* img = cvCaptureFromAVI("cap_rgb.avi");
	CvCapture* dpt = cvCaptureFromAVI("cap_depth.avi");

	IplImage *image = cvCreateImage(cvSize(640, 480), 8, 3);
	IplImage *g_image = cvCreateImage(cvSize(640, 480), 8, 1);
	IplImage *depth = cvCreateImage(cvSize(640, 480), 16, 1);

	//SURF related things
	CvMemStorage* storage = cvCreateMemStorage(0);
	CvSeq *imageKeypoints = 0, *imageDescriptors = 0;
	CvSURFParams params = cvSURFParams(1000, 1);

	//loop
	while(1) {

		if(!cvGrabFrame(img) || !cvGrabFrame(dpt)) {
			printf("Could not grab a frame\n\7");
			return 0;
		}
		image = cvRetrieveFrame(img);
		depth = cvRetrieveFrame(dpt);
		cvCvtColor(image, g_image, CV_RGB2GRAY);

		//extract features
		cvExtractSURF( g_image, 0, &imageKeypoints, &imageDescriptors, storage, params );

		//draw
		for(int i = 0; i < imageKeypoints->total; i++ ) {
			CvSURFPoint* r = (CvSURFPoint*)cvGetSeqElem( imageKeypoints, i );
			CvPoint center;
			int radius;
			center.x = cvRound(r->pt.x);
			center.y = cvRound(r->pt.y);
			radius = cvRound(r->size*1.2/9.*2);
			cvCircle( g_image, center, radius, CV_RGB(255, 255, 255), 1, 8, 0 );
		}

		cvShowImage("w1", image);
		cvShowImage("w2", g_image);
		cvWaitKey(0);

		//clear
		cvClearMemStorage(storage);

	}

	return 0;
}